# EzEpoch SSH Key Generator v1.0

Generate SSH keys for secure cloud GPU access with a simple GUI.

**ARC Technologies LLC - Patent Pending**

---

## Quick Start

### Windows
1. Double-click `run_windows.bat`
2. Enter a key name (or use default)
3. Click "Generate SSH Key"
4. Copy the public key and paste it into EzEpoch

### Mac/Linux
1. Open Terminal
2. Run: `chmod +x run_mac_linux.sh && ./run_mac_linux.sh`
3. Enter a key name (or use default)
4. Click "Generate SSH Key"
5. Copy the public key and paste it into EzEpoch

---

## Requirements

- **Python 3.7+** (with tkinter for GUI)
- **OpenSSH** (usually pre-installed)

### Installing OpenSSH

**Windows 10/11:**
1. Go to Settings > Apps > Optional Features
2. Click "Add a feature"
3. Search for "OpenSSH Client"
4. Click Install

**Mac:** Pre-installed

**Linux:** Pre-installed (or `sudo apt install openssh-client`)

---

## What This Does

1. Creates a secure SSH key pair (ED25519 or RSA)
2. Saves the private key to your `~/.ssh/` folder
3. Shows you the public key to copy into EzEpoch

---

## Key Types

- **ED25519** (Recommended): Modern, fast, secure, smaller keys
- **RSA 4096**: Legacy compatibility, larger keys, works everywhere

---

## Where Are My Keys?

| Platform | Location |
|----------|----------|
| Windows | `C:\Users\YourName\.ssh\` |
| Mac | `/Users/YourName/.ssh/` |
| Linux | `/home/YourName/.ssh/` |

---

## CLI Mode

Run without GUI: `python ssh_keygen.py --cli`

---

## Troubleshooting

### "ssh-keygen not found"
Install OpenSSH (see Requirements above)

### "Permission denied"
Run as Administrator (Windows) or with sudo (Mac/Linux)

### "Key already exists"
Choose a different key name or delete the existing key

---

## Support

Visit: https://ezepoch.com/help

---

 2025 ARC Technologies LLC | Patent Pending

